/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jnr.netdb.Service;
import jnr.netdb.ServicesDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IANAServicesDB
implements ServicesDB {
    private final Map<Integer, Service> tcpPortToService;
    private final Map<Integer, Service> udpPortToService;
    private final Map<String, Service> tcpNameToService;
    private final Map<String, Service> udpNameToService;
    private final List<Service> allServices;

    private IANAServicesDB(Map<String, Service> map, Map<String, Service> map2, Map<Integer, Service> map3, Map<Integer, Service> map4) {
        this.tcpNameToService = map;
        this.udpNameToService = map2;
        this.tcpPortToService = map3;
        this.udpPortToService = map4;
        ArrayList<Service> arrayList = new ArrayList<Service>(map.size() + map2.size());
        arrayList.addAll(map.values());
        arrayList.addAll(map2.values());
        this.allServices = Collections.unmodifiableList(arrayList);
    }

    public static final IANAServicesDB getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public final Service getServiceByName(String string, String string2) {
        if ("tcp".equals(string2)) {
            return this.tcpNameToService.get(string);
        }
        if ("udp".equals(string2)) {
            return this.udpNameToService.get(string);
        }
        if (string2 == null) {
            Service service = this.tcpNameToService.get(string);
            return service != null ? service : this.udpNameToService.get(string);
        }
        return null;
    }

    @Override
    public final Service getServiceByPort(Integer n, String string) {
        if ("tcp".equals(string)) {
            return this.tcpPortToService.get(n);
        }
        if ("udp".equals(string)) {
            return this.udpPortToService.get(n);
        }
        if (string == null) {
            Service service = this.tcpPortToService.get(n);
            return service != null ? service : this.udpPortToService.get(n);
        }
        return null;
    }

    public final List<Service> getAllServices() {
        return this.allServices;
    }

    private static final IANAServicesDB buildServices() {
        ServicesBuilder servicesBuilder = new ServicesBuilder();
        servicesBuilder.add("spr-itunes", "tcp", 0);
        servicesBuilder.add("spl-itunes", "tcp", 0);
        servicesBuilder.add("tcpmux", "tcp", 1);
        servicesBuilder.add("tcpmux", "udp", 1);
        servicesBuilder.add("compressnet", "tcp", 2);
        servicesBuilder.add("compressnet", "udp", 2);
        servicesBuilder.add("compressnet", "tcp", 3);
        servicesBuilder.add("compressnet", "udp", 3);
        servicesBuilder.add("rje", "tcp", 5);
        servicesBuilder.add("rje", "udp", 5);
        servicesBuilder.add("echo", "tcp", 7);
        servicesBuilder.add("echo", "udp", 7);
        servicesBuilder.add("discard", "tcp", 9);
        servicesBuilder.add("discard", "udp", 9);
        servicesBuilder.add("discard/sctp", 9);
        servicesBuilder.add("discard/dccp", 9);
        servicesBuilder.add("systat", "tcp", 11);
        servicesBuilder.add("systat", "udp", 11);
        servicesBuilder.add("daytime", "tcp", 13);
        servicesBuilder.add("daytime", "udp", 13);
        servicesBuilder.add("qotd", "tcp", 17);
        servicesBuilder.add("qotd", "udp", 17);
        servicesBuilder.add("msp", "tcp", 18);
        servicesBuilder.add("msp", "udp", 18);
        servicesBuilder.add("chargen", "tcp", 19);
        servicesBuilder.add("chargen", "udp", 19);
        servicesBuilder.add("ftp-data", "tcp", 20);
        servicesBuilder.add("ftp-data", "udp", 20);
        servicesBuilder.add("ftp-data/sctp", 20);
        servicesBuilder.add("ftp", "tcp", 21);
        servicesBuilder.add("ftp", "udp", 21);
        servicesBuilder.add("ftp/sctp", 21);
        servicesBuilder.add("ssh", "tcp", 22);
        servicesBuilder.add("ssh", "udp", 22);
        servicesBuilder.add("ssh/sctp", 22);
        servicesBuilder.add("telnet", "tcp", 23);
        servicesBuilder.add("telnet", "udp", 23);
        servicesBuilder.add("smtp", "tcp", 25);
        servicesBuilder.add("smtp", "udp", 25);
        servicesBuilder.add("nsw-fe", "tcp", 27);
        servicesBuilder.add("nsw-fe", "udp", 27);
        servicesBuilder.add("msg-icp", "tcp", 29);
        servicesBuilder.add("msg-icp", "udp", 29);
        servicesBuilder.add("msg-auth", "tcp", 31);
        servicesBuilder.add("msg-auth", "udp", 31);
        servicesBuilder.add("dsp", "tcp", 33);
        servicesBuilder.add("dsp", "udp", 33);
        servicesBuilder.add("time", "tcp", 37);
        servicesBuilder.add("time", "udp", 37);
        servicesBuilder.add("rap", "tcp", 38);
        servicesBuilder.add("rap", "udp", 38);
        servicesBuilder.add("rlp", "tcp", 39);
        servicesBuilder.add("rlp", "udp", 39);
        servicesBuilder.add("graphics", "tcp", 41);
        servicesBuilder.add("graphics", "udp", 41);
        servicesBuilder.add("name", "tcp", 42);
        servicesBuilder.add("name", "udp", 42);
        servicesBuilder.add("nameserver", "tcp", 42);
        servicesBuilder.add("nameserver", "udp", 42);
        servicesBuilder.add("nicname", "tcp", 43);
        servicesBuilder.add("nicname", "udp", 43);
        servicesBuilder.add("mpm-flags", "tcp", 44);
        servicesBuilder.add("mpm-flags", "udp", 44);
        servicesBuilder.add("mpm", "tcp", 45);
        servicesBuilder.add("mpm", "udp", 45);
        servicesBuilder.add("mpm-snd", "tcp", 46);
        servicesBuilder.add("mpm-snd", "udp", 46);
        servicesBuilder.add("ni-ftp", "tcp", 47);
        servicesBuilder.add("ni-ftp", "udp", 47);
        servicesBuilder.add("auditd", "tcp", 48);
        servicesBuilder.add("auditd", "udp", 48);
        servicesBuilder.add("tacacs", "tcp", 49);
        servicesBuilder.add("tacacs", "udp", 49);
        servicesBuilder.add("re-mail-ck", "tcp", 50);
        servicesBuilder.add("re-mail-ck", "udp", 50);
        servicesBuilder.add("la-maint", "tcp", 51);
        servicesBuilder.add("la-maint", "udp", 51);
        servicesBuilder.add("xns-time", "tcp", 52);
        servicesBuilder.add("xns-time", "udp", 52);
        servicesBuilder.add("domain", "tcp", 53);
        servicesBuilder.add("domain", "udp", 53);
        servicesBuilder.add("xns-ch", "tcp", 54);
        servicesBuilder.add("xns-ch", "udp", 54);
        servicesBuilder.add("isi-gl", "tcp", 55);
        servicesBuilder.add("isi-gl", "udp", 55);
        servicesBuilder.add("xns-auth", "tcp", 56);
        servicesBuilder.add("xns-auth", "udp", 56);
        servicesBuilder.add("xns-mail", "tcp", 58);
        servicesBuilder.add("xns-mail", "udp", 58);
        servicesBuilder.add("ni-mail", "tcp", 61);
        servicesBuilder.add("ni-mail", "udp", 61);
        servicesBuilder.add("acas", "tcp", 62);
        servicesBuilder.add("acas", "udp", 62);
        servicesBuilder.add("whois++", "tcp", 63);
        servicesBuilder.add("whois++", "udp", 63);
        servicesBuilder.add("covia", "tcp", 64);
        servicesBuilder.add("covia", "udp", 64);
        servicesBuilder.add("tacacs-ds", "tcp", 65);
        servicesBuilder.add("tacacs-ds", "udp", 65);
        servicesBuilder.add("sql*net", "tcp", 66);
        servicesBuilder.add("sql*net", "udp", 66);
        servicesBuilder.add("bootps", "tcp", 67);
        servicesBuilder.add("bootps", "udp", 67);
        servicesBuilder.add("bootpc", "tcp", 68);
        servicesBuilder.add("bootpc", "udp", 68);
        servicesBuilder.add("tftp", "tcp", 69);
        servicesBuilder.add("tftp", "udp", 69);
        servicesBuilder.add("gopher", "tcp", 70);
        servicesBuilder.add("gopher", "udp", 70);
        servicesBuilder.add("netrjs-1", "tcp", 71);
        servicesBuilder.add("netrjs-1", "udp", 71);
        servicesBuilder.add("netrjs-2", "tcp", 72);
        servicesBuilder.add("netrjs-2", "udp", 72);
        servicesBuilder.add("netrjs-3", "tcp", 73);
        servicesBuilder.add("netrjs-3", "udp", 73);
        servicesBuilder.add("netrjs-4", "tcp", 74);
        servicesBuilder.add("netrjs-4", "udp", 74);
        servicesBuilder.add("deos", "tcp", 76);
        servicesBuilder.add("deos", "udp", 76);
        servicesBuilder.add("vettcp", "tcp", 78);
        servicesBuilder.add("vettcp", "udp", 78);
        servicesBuilder.add("finger", "tcp", 79);
        servicesBuilder.add("finger", "udp", 79);
        servicesBuilder.add("http", "tcp", 80);
        servicesBuilder.add("http", "udp", 80);
        servicesBuilder.add("www", "tcp", 80);
        servicesBuilder.add("www", "udp", 80);
        servicesBuilder.add("www-http", "tcp", 80);
        servicesBuilder.add("www-http", "udp", 80);
        servicesBuilder.add("http/sctp", 80);
        servicesBuilder.add("xfer", "tcp", 82);
        servicesBuilder.add("xfer", "udp", 82);
        servicesBuilder.add("mit-ml-dev", "tcp", 83);
        servicesBuilder.add("mit-ml-dev", "udp", 83);
        servicesBuilder.add("ctf", "tcp", 84);
        servicesBuilder.add("ctf", "udp", 84);
        servicesBuilder.add("mit-ml-dev", "tcp", 85);
        servicesBuilder.add("mit-ml-dev", "udp", 85);
        servicesBuilder.add("mfcobol", "tcp", 86);
        servicesBuilder.add("mfcobol", "udp", 86);
        servicesBuilder.add("kerberos", "tcp", 88);
        servicesBuilder.add("kerberos", "udp", 88);
        servicesBuilder.add("su-mit-tg", "tcp", 89);
        servicesBuilder.add("su-mit-tg", "udp", 89);
        servicesBuilder.add("dnsix", "tcp", 90);
        servicesBuilder.add("dnsix", "udp", 90);
        servicesBuilder.add("mit-dov", "tcp", 91);
        servicesBuilder.add("mit-dov", "udp", 91);
        servicesBuilder.add("npp", "tcp", 92);
        servicesBuilder.add("npp", "udp", 92);
        servicesBuilder.add("dcp", "tcp", 93);
        servicesBuilder.add("dcp", "udp", 93);
        servicesBuilder.add("objcall", "tcp", 94);
        servicesBuilder.add("objcall", "udp", 94);
        servicesBuilder.add("supdup", "tcp", 95);
        servicesBuilder.add("supdup", "udp", 95);
        servicesBuilder.add("dixie", "tcp", 96);
        servicesBuilder.add("dixie", "udp", 96);
        servicesBuilder.add("swift-rvf", "tcp", 97);
        servicesBuilder.add("swift-rvf", "udp", 97);
        servicesBuilder.add("tacnews", "tcp", 98);
        servicesBuilder.add("tacnews", "udp", 98);
        servicesBuilder.add("metagram", "tcp", 99);
        servicesBuilder.add("metagram", "udp", 99);
        servicesBuilder.add("newacct", "tcp", 100);
        servicesBuilder.add("hostname", "tcp", 101);
        servicesBuilder.add("hostname", "udp", 101);
        servicesBuilder.add("iso-tsap", "tcp", 102);
        servicesBuilder.add("iso-tsap", "udp", 102);
        servicesBuilder.add("gppitnp", "tcp", 103);
        servicesBuilder.add("gppitnp", "udp", 103);
        servicesBuilder.add("acr-nema", "tcp", 104);
        servicesBuilder.add("acr-nema", "udp", 104);
        servicesBuilder.add("cso", "tcp", 105);
        servicesBuilder.add("cso", "udp", 105);
        servicesBuilder.add("csnet-ns", "tcp", 105);
        servicesBuilder.add("csnet-ns", "udp", 105);
        servicesBuilder.add("3com-tsmux", "tcp", 106);
        servicesBuilder.add("3com-tsmux", "udp", 106);
        servicesBuilder.add("rtelnet", "tcp", 107);
        servicesBuilder.add("rtelnet", "udp", 107);
        servicesBuilder.add("snagas", "tcp", 108);
        servicesBuilder.add("snagas", "udp", 108);
        servicesBuilder.add("pop2", "tcp", 109);
        servicesBuilder.add("pop2", "udp", 109);
        servicesBuilder.add("pop3", "tcp", 110);
        servicesBuilder.add("pop3", "udp", 110);
        servicesBuilder.add("sunrpc", "tcp", 111);
        servicesBuilder.add("sunrpc", "udp", 111);
        servicesBuilder.add("mcidas", "tcp", 112);
        servicesBuilder.add("mcidas", "udp", 112);
        servicesBuilder.add("ident", "tcp", 113);
        servicesBuilder.add("auth", "tcp", 113);
        servicesBuilder.add("auth", "udp", 113);
        servicesBuilder.add("sftp", "tcp", 115);
        servicesBuilder.add("sftp", "udp", 115);
        servicesBuilder.add("ansanotify", "tcp", 116);
        servicesBuilder.add("ansanotify", "udp", 116);
        servicesBuilder.add("uucp-path", "tcp", 117);
        servicesBuilder.add("uucp-path", "udp", 117);
        servicesBuilder.add("sqlserv", "tcp", 118);
        servicesBuilder.add("sqlserv", "udp", 118);
        servicesBuilder.add("nntp", "tcp", 119);
        servicesBuilder.add("nntp", "udp", 119);
        servicesBuilder.add("cfdptkt", "tcp", 120);
        servicesBuilder.add("cfdptkt", "udp", 120);
        servicesBuilder.add("erpc", "tcp", 121);
        servicesBuilder.add("erpc", "udp", 121);
        servicesBuilder.add("smakynet", "tcp", 122);
        servicesBuilder.add("smakynet", "udp", 122);
        servicesBuilder.add("ntp", "tcp", 123);
        servicesBuilder.add("ntp", "udp", 123);
        servicesBuilder.add("ansatrader", "tcp", 124);
        servicesBuilder.add("ansatrader", "udp", 124);
        servicesBuilder.add("locus-map", "tcp", 125);
        servicesBuilder.add("locus-map", "udp", 125);
        servicesBuilder.add("nxedit", "tcp", 126);
        servicesBuilder.add("nxedit", "udp", 126);
        servicesBuilder.add("locus-con", "tcp", 127);
        servicesBuilder.add("locus-con", "udp", 127);
        servicesBuilder.add("gss-xlicen", "tcp", 128);
        servicesBuilder.add("gss-xlicen", "udp", 128);
        servicesBuilder.add("pwdgen", "tcp", 129);
        servicesBuilder.add("pwdgen", "udp", 129);
        servicesBuilder.add("cisco-fna", "tcp", 130);
        servicesBuilder.add("cisco-fna", "udp", 130);
        servicesBuilder.add("cisco-tna", "tcp", 131);
        servicesBuilder.add("cisco-tna", "udp", 131);
        servicesBuilder.add("cisco-sys", "tcp", 132);
        servicesBuilder.add("cisco-sys", "udp", 132);
        servicesBuilder.add("statsrv", "tcp", 133);
        servicesBuilder.add("statsrv", "udp", 133);
        servicesBuilder.add("ingres-net", "tcp", 134);
        servicesBuilder.add("ingres-net", "udp", 134);
        servicesBuilder.add("epmap", "tcp", 135);
        servicesBuilder.add("epmap", "udp", 135);
        servicesBuilder.add("profile", "tcp", 136);
        servicesBuilder.add("profile", "udp", 136);
        servicesBuilder.add("netbios-ns", "tcp", 137);
        servicesBuilder.add("netbios-ns", "udp", 137);
        servicesBuilder.add("netbios-dgm", "tcp", 138);
        servicesBuilder.add("netbios-dgm", "udp", 138);
        servicesBuilder.add("netbios-ssn", "tcp", 139);
        servicesBuilder.add("netbios-ssn", "udp", 139);
        servicesBuilder.add("emfis-data", "tcp", 140);
        servicesBuilder.add("emfis-data", "udp", 140);
        servicesBuilder.add("emfis-cntl", "tcp", 141);
        servicesBuilder.add("emfis-cntl", "udp", 141);
        servicesBuilder.add("bl-idm", "tcp", 142);
        servicesBuilder.add("bl-idm", "udp", 142);
        servicesBuilder.add("imap", "tcp", 143);
        servicesBuilder.add("imap", "udp", 143);
        servicesBuilder.add("uma", "tcp", 144);
        servicesBuilder.add("uma", "udp", 144);
        servicesBuilder.add("uaac", "tcp", 145);
        servicesBuilder.add("uaac", "udp", 145);
        servicesBuilder.add("iso-tp0", "tcp", 146);
        servicesBuilder.add("iso-tp0", "udp", 146);
        servicesBuilder.add("iso-ip", "tcp", 147);
        servicesBuilder.add("iso-ip", "udp", 147);
        servicesBuilder.add("jargon", "tcp", 148);
        servicesBuilder.add("jargon", "udp", 148);
        servicesBuilder.add("aed-512", "tcp", 149);
        servicesBuilder.add("aed-512", "udp", 149);
        servicesBuilder.add("sql-net", "tcp", 150);
        servicesBuilder.add("sql-net", "udp", 150);
        servicesBuilder.add("hems", "tcp", 151);
        servicesBuilder.add("hems", "udp", 151);
        servicesBuilder.add("bftp", "tcp", 152);
        servicesBuilder.add("bftp", "udp", 152);
        servicesBuilder.add("sgmp", "tcp", 153);
        servicesBuilder.add("sgmp", "udp", 153);
        servicesBuilder.add("netsc-prod", "tcp", 154);
        servicesBuilder.add("netsc-prod", "udp", 154);
        servicesBuilder.add("netsc-dev", "tcp", 155);
        servicesBuilder.add("netsc-dev", "udp", 155);
        servicesBuilder.add("sqlsrv", "tcp", 156);
        servicesBuilder.add("sqlsrv", "udp", 156);
        servicesBuilder.add("knet-cmp", "tcp", 157);
        servicesBuilder.add("knet-cmp", "udp", 157);
        servicesBuilder.add("pcmail-srv", "tcp", 158);
        servicesBuilder.add("pcmail-srv", "udp", 158);
        servicesBuilder.add("nss-routing", "tcp", 159);
        servicesBuilder.add("nss-routing", "udp", 159);
        servicesBuilder.add("sgmp-traps", "tcp", 160);
        servicesBuilder.add("sgmp-traps", "udp", 160);
        servicesBuilder.add("snmp", "tcp", 161);
        servicesBuilder.add("snmp", "udp", 161);
        servicesBuilder.add("snmptrap", "tcp", 162);
        servicesBuilder.add("snmptrap", "udp", 162);
        servicesBuilder.add("cmip-man", "tcp", 163);
        servicesBuilder.add("cmip-man", "udp", 163);
        servicesBuilder.add("cmip-agent", "tcp", 164);
        servicesBuilder.add("cmip-agent", "udp", 164);
        servicesBuilder.add("xns-courier", "tcp", 165);
        servicesBuilder.add("xns-courier", "udp", 165);
        servicesBuilder.add("s-net", "tcp", 166);
        servicesBuilder.add("s-net", "udp", 166);
        servicesBuilder.add("namp", "tcp", 167);
        servicesBuilder.add("namp", "udp", 167);
        servicesBuilder.add("rsvd", "tcp", 168);
        servicesBuilder.add("rsvd", "udp", 168);
        servicesBuilder.add("send", "tcp", 169);
        servicesBuilder.add("send", "udp", 169);
        servicesBuilder.add("print-srv", "tcp", 170);
        servicesBuilder.add("print-srv", "udp", 170);
        servicesBuilder.add("multiplex", "tcp", 171);
        servicesBuilder.add("multiplex", "udp", 171);
        servicesBuilder.add("cl/1", "tcp", 172);
        servicesBuilder.add("cl/1", "udp", 172);
        servicesBuilder.add("xyplex-mux", "tcp", 173);
        servicesBuilder.add("xyplex-mux", "udp", 173);
        servicesBuilder.add("mailq", "tcp", 174);
        servicesBuilder.add("mailq", "udp", 174);
        servicesBuilder.add("vmnet", "tcp", 175);
        servicesBuilder.add("vmnet", "udp", 175);
        servicesBuilder.add("genrad-mux", "tcp", 176);
        servicesBuilder.add("genrad-mux", "udp", 176);
        servicesBuilder.add("xdmcp", "tcp", 177);
        servicesBuilder.add("xdmcp", "udp", 177);
        servicesBuilder.add("nextstep", "tcp", 178);
        servicesBuilder.add("nextstep", "udp", 178);
        servicesBuilder.add("bgp", "tcp", 179);
        servicesBuilder.add("bgp", "udp", 179);
        servicesBuilder.add("bgp/sctp", 179);
        servicesBuilder.add("ris", "tcp", 180);
        servicesBuilder.add("ris", "udp", 180);
        servicesBuilder.add("unify", "tcp", 181);
        servicesBuilder.add("unify", "udp", 181);
        servicesBuilder.add("audit", "tcp", 182);
        servicesBuilder.add("audit", "udp", 182);
        servicesBuilder.add("ocbinder", "tcp", 183);
        servicesBuilder.add("ocbinder", "udp", 183);
        servicesBuilder.add("ocserver", "tcp", 184);
        servicesBuilder.add("ocserver", "udp", 184);
        servicesBuilder.add("remote-kis", "tcp", 185);
        servicesBuilder.add("remote-kis", "udp", 185);
        servicesBuilder.add("kis", "tcp", 186);
        servicesBuilder.add("kis", "udp", 186);
        servicesBuilder.add("aci", "tcp", 187);
        servicesBuilder.add("aci", "udp", 187);
        servicesBuilder.add("mumps", "tcp", 188);
        servicesBuilder.add("mumps", "udp", 188);
        servicesBuilder.add("qft", "tcp", 189);
        servicesBuilder.add("qft", "udp", 189);
        servicesBuilder.add("gacp", "tcp", 190);
        servicesBuilder.add("gacp", "udp", 190);
        servicesBuilder.add("prospero", "tcp", 191);
        servicesBuilder.add("prospero", "udp", 191);
        servicesBuilder.add("osu-nms", "tcp", 192);
        servicesBuilder.add("osu-nms", "udp", 192);
        servicesBuilder.add("srmp", "tcp", 193);
        servicesBuilder.add("srmp", "udp", 193);
        servicesBuilder.add("irc", "tcp", 194);
        servicesBuilder.add("irc", "udp", 194);
        servicesBuilder.add("dn6-nlm-aud", "tcp", 195);
        servicesBuilder.add("dn6-nlm-aud", "udp", 195);
        servicesBuilder.add("dn6-smm-red", "tcp", 196);
        servicesBuilder.add("dn6-smm-red", "udp", 196);
        servicesBuilder.add("dls", "tcp", 197);
        servicesBuilder.add("dls", "udp", 197);
        servicesBuilder.add("dls-mon", "tcp", 198);
        servicesBuilder.add("dls-mon", "udp", 198);
        servicesBuilder.add("smux", "tcp", 199);
        servicesBuilder.add("smux", "udp", 199);
        servicesBuilder.add("src", "tcp", 200);
        servicesBuilder.add("src", "udp", 200);
        servicesBuilder.add("at-rtmp", "tcp", 201);
        servicesBuilder.add("at-rtmp", "udp", 201);
        servicesBuilder.add("at-nbp", "tcp", 202);
        servicesBuilder.add("at-nbp", "udp", 202);
        servicesBuilder.add("at-3", "tcp", 203);
        servicesBuilder.add("at-3", "udp", 203);
        servicesBuilder.add("at-echo", "tcp", 204);
        servicesBuilder.add("at-echo", "udp", 204);
        servicesBuilder.add("at-5", "tcp", 205);
        servicesBuilder.add("at-5", "udp", 205);
        servicesBuilder.add("at-zis", "tcp", 206);
        servicesBuilder.add("at-zis", "udp", 206);
        servicesBuilder.add("at-7", "tcp", 207);
        servicesBuilder.add("at-7", "udp", 207);
        servicesBuilder.add("at-8", "tcp", 208);
        servicesBuilder.add("at-8", "udp", 208);
        servicesBuilder.add("qmtp", "tcp", 209);
        servicesBuilder.add("qmtp", "udp", 209);
        servicesBuilder.add("z39.50", "tcp", 210);
        servicesBuilder.add("z39.50", "udp", 210);
        servicesBuilder.add("914c/g", "tcp", 211);
        servicesBuilder.add("914c/g", "udp", 211);
        servicesBuilder.add("anet", "tcp", 212);
        servicesBuilder.add("anet", "udp", 212);
        servicesBuilder.add("ipx", "tcp", 213);
        servicesBuilder.add("ipx", "udp", 213);
        servicesBuilder.add("vmpwscs", "tcp", 214);
        servicesBuilder.add("vmpwscs", "udp", 214);
        servicesBuilder.add("softpc", "tcp", 215);
        servicesBuilder.add("softpc", "udp", 215);
        servicesBuilder.add("CAIlic", "tcp", 216);
        servicesBuilder.add("CAIlic", "udp", 216);
        servicesBuilder.add("dbase", "tcp", 217);
        servicesBuilder.add("dbase", "udp", 217);
        servicesBuilder.add("mpp", "tcp", 218);
        servicesBuilder.add("mpp", "udp", 218);
        servicesBuilder.add("uarps", "tcp", 219);
        servicesBuilder.add("uarps", "udp", 219);
        servicesBuilder.add("imap3", "tcp", 220);
        servicesBuilder.add("imap3", "udp", 220);
        servicesBuilder.add("fln-spx", "tcp", 221);
        servicesBuilder.add("fln-spx", "udp", 221);
        servicesBuilder.add("rsh-spx", "tcp", 222);
        servicesBuilder.add("rsh-spx", "udp", 222);
        servicesBuilder.add("cdc", "tcp", 223);
        servicesBuilder.add("cdc", "udp", 223);
        servicesBuilder.add("masqdialer", "tcp", 224);
        servicesBuilder.add("masqdialer", "udp", 224);
        servicesBuilder.add("direct", "tcp", 242);
        servicesBuilder.add("direct", "udp", 242);
        servicesBuilder.add("sur-meas", "tcp", 243);
        servicesBuilder.add("sur-meas", "udp", 243);
        servicesBuilder.add("inbusiness", "tcp", 244);
        servicesBuilder.add("inbusiness", "udp", 244);
        servicesBuilder.add("link", "tcp", 245);
        servicesBuilder.add("link", "udp", 245);
        servicesBuilder.add("dsp3270", "tcp", 246);
        servicesBuilder.add("dsp3270", "udp", 246);
        servicesBuilder.add("subntbcst_tftp", "tcp", 247);
        servicesBuilder.add("subntbcst_tftp", "udp", 247);
        servicesBuilder.add("bhfhs", "tcp", 248);
        servicesBuilder.add("bhfhs", "udp", 248);
        servicesBuilder.add("rap", "tcp", 256);
        servicesBuilder.add("rap", "udp", 256);
        servicesBuilder.add("set", "tcp", 257);
        servicesBuilder.add("set", "udp", 257);
        servicesBuilder.add("esro-gen", "tcp", 259);
        servicesBuilder.add("esro-gen", "udp", 259);
        servicesBuilder.add("openport", "tcp", 260);
        servicesBuilder.add("openport", "udp", 260);
        servicesBuilder.add("nsiiops", "tcp", 261);
        servicesBuilder.add("nsiiops", "udp", 261);
        servicesBuilder.add("arcisdms", "tcp", 262);
        servicesBuilder.add("arcisdms", "udp", 262);
        servicesBuilder.add("hdap", "tcp", 263);
        servicesBuilder.add("hdap", "udp", 263);
        servicesBuilder.add("bgmp", "tcp", 264);
        servicesBuilder.add("bgmp", "udp", 264);
        servicesBuilder.add("x-bone-ctl", "tcp", 265);
        servicesBuilder.add("x-bone-ctl", "udp", 265);
        servicesBuilder.add("sst", "tcp", 266);
        servicesBuilder.add("sst", "udp", 266);
        servicesBuilder.add("td-service", "tcp", 267);
        servicesBuilder.add("td-service", "udp", 267);
        servicesBuilder.add("td-replica", "tcp", 268);
        servicesBuilder.add("td-replica", "udp", 268);
        servicesBuilder.add("manet", "tcp", 269);
        servicesBuilder.add("manet", "udp", 269);
        servicesBuilder.add("http-mgmt", "tcp", 280);
        servicesBuilder.add("http-mgmt", "udp", 280);
        servicesBuilder.add("personal-link", "tcp", 281);
        servicesBuilder.add("personal-link", "udp", 281);
        servicesBuilder.add("cableport-ax", "tcp", 282);
        servicesBuilder.add("cableport-ax", "udp", 282);
        servicesBuilder.add("rescap", "tcp", 283);
        servicesBuilder.add("rescap", "udp", 283);
        servicesBuilder.add("corerjd", "tcp", 284);
        servicesBuilder.add("corerjd", "udp", 284);
        servicesBuilder.add("fxp", "tcp", 286);
        servicesBuilder.add("fxp", "udp", 286);
        servicesBuilder.add("k-block", "tcp", 287);
        servicesBuilder.add("k-block", "udp", 287);
        servicesBuilder.add("novastorbakcup", "tcp", 308);
        servicesBuilder.add("novastorbakcup", "udp", 308);
        servicesBuilder.add("entrusttime", "tcp", 309);
        servicesBuilder.add("entrusttime", "udp", 309);
        servicesBuilder.add("bhmds", "tcp", 310);
        servicesBuilder.add("bhmds", "udp", 310);
        servicesBuilder.add("asip-webadmin", "tcp", 311);
        servicesBuilder.add("asip-webadmin", "udp", 311);
        servicesBuilder.add("vslmp", "tcp", 312);
        servicesBuilder.add("vslmp", "udp", 312);
        servicesBuilder.add("magenta-logic", "tcp", 313);
        servicesBuilder.add("magenta-logic", "udp", 313);
        servicesBuilder.add("opalis-robot", "tcp", 314);
        servicesBuilder.add("opalis-robot", "udp", 314);
        servicesBuilder.add("dpsi", "tcp", 315);
        servicesBuilder.add("dpsi", "udp", 315);
        servicesBuilder.add("decauth", "tcp", 316);
        servicesBuilder.add("decauth", "udp", 316);
        servicesBuilder.add("zannet", "tcp", 317);
        servicesBuilder.add("zannet", "udp", 317);
        servicesBuilder.add("pkix-timestamp", "tcp", 318);
        servicesBuilder.add("pkix-timestamp", "udp", 318);
        servicesBuilder.add("ptp-event", "tcp", 319);
        servicesBuilder.add("ptp-event", "udp", 319);
        servicesBuilder.add("ptp-general", "tcp", 320);
        servicesBuilder.add("ptp-general", "udp", 320);
        servicesBuilder.add("pip", "tcp", 321);
        servicesBuilder.add("pip", "udp", 321);
        servicesBuilder.add("rtsps", "tcp", 322);
        servicesBuilder.add("rtsps", "udp", 322);
        servicesBuilder.add("texar", "tcp", 333);
        servicesBuilder.add("texar", "udp", 333);
        servicesBuilder.add("pdap", "tcp", 344);
        servicesBuilder.add("pdap", "udp", 344);
        servicesBuilder.add("pawserv", "tcp", 345);
        servicesBuilder.add("pawserv", "udp", 345);
        servicesBuilder.add("zserv", "tcp", 346);
        servicesBuilder.add("zserv", "udp", 346);
        servicesBuilder.add("fatserv", "tcp", 347);
        servicesBuilder.add("fatserv", "udp", 347);
        servicesBuilder.add("csi-sgwp", "tcp", 348);
        servicesBuilder.add("csi-sgwp", "udp", 348);
        servicesBuilder.add("mftp", "tcp", 349);
        servicesBuilder.add("mftp", "udp", 349);
        servicesBuilder.add("matip-type-a", "tcp", 350);
        servicesBuilder.add("matip-type-a", "udp", 350);
        servicesBuilder.add("matip-type-b", "tcp", 351);
        servicesBuilder.add("matip-type-b", "udp", 351);
        servicesBuilder.add("bhoetty", "tcp", 351);
        servicesBuilder.add("bhoetty", "udp", 351);
        servicesBuilder.add("dtag-ste-sb", "tcp", 352);
        servicesBuilder.add("dtag-ste-sb", "udp", 352);
        servicesBuilder.add("bhoedap4", "tcp", 352);
        servicesBuilder.add("bhoedap4", "udp", 352);
        servicesBuilder.add("ndsauth", "tcp", 353);
        servicesBuilder.add("ndsauth", "udp", 353);
        servicesBuilder.add("bh611", "tcp", 354);
        servicesBuilder.add("bh611", "udp", 354);
        servicesBuilder.add("datex-asn", "tcp", 355);
        servicesBuilder.add("datex-asn", "udp", 355);
        servicesBuilder.add("cloanto-net-1", "tcp", 356);
        servicesBuilder.add("cloanto-net-1", "udp", 356);
        servicesBuilder.add("bhevent", "tcp", 357);
        servicesBuilder.add("bhevent", "udp", 357);
        servicesBuilder.add("shrinkwrap", "tcp", 358);
        servicesBuilder.add("shrinkwrap", "udp", 358);
        servicesBuilder.add("nsrmp", "tcp", 359);
        servicesBuilder.add("nsrmp", "udp", 359);
        servicesBuilder.add("scoi2odialog", "tcp", 360);
        servicesBuilder.add("scoi2odialog", "udp", 360);
        servicesBuilder.add("semantix", "tcp", 361);
        servicesBuilder.add("semantix", "udp", 361);
        servicesBuilder.add("srssend", "tcp", 362);
        servicesBuilder.add("srssend", "udp", 362);
        servicesBuilder.add("rsvp_tunnel", "tcp", 363);
        servicesBuilder.add("rsvp_tunnel", "udp", 363);
        servicesBuilder.add("aurora-cmgr", "tcp", 364);
        servicesBuilder.add("aurora-cmgr", "udp", 364);
        servicesBuilder.add("dtk", "tcp", 365);
        servicesBuilder.add("dtk", "udp", 365);
        servicesBuilder.add("odmr", "tcp", 366);
        servicesBuilder.add("odmr", "udp", 366);
        servicesBuilder.add("mortgageware", "tcp", 367);
        servicesBuilder.add("mortgageware", "udp", 367);
        servicesBuilder.add("qbikgdp", "tcp", 368);
        servicesBuilder.add("qbikgdp", "udp", 368);
        servicesBuilder.add("rpc2portmap", "tcp", 369);
        servicesBuilder.add("rpc2portmap", "udp", 369);
        servicesBuilder.add("codaauth2", "tcp", 370);
        servicesBuilder.add("codaauth2", "udp", 370);
        servicesBuilder.add("clearcase", "tcp", 371);
        servicesBuilder.add("clearcase", "udp", 371);
        servicesBuilder.add("ulistproc", "tcp", 372);
        servicesBuilder.add("ulistproc", "udp", 372);
        servicesBuilder.add("legent-1", "tcp", 373);
        servicesBuilder.add("legent-1", "udp", 373);
        servicesBuilder.add("legent-2", "tcp", 374);
        servicesBuilder.add("legent-2", "udp", 374);
        servicesBuilder.add("hassle", "tcp", 375);
        servicesBuilder.add("hassle", "udp", 375);
        servicesBuilder.add("nip", "tcp", 376);
        servicesBuilder.add("nip", "udp", 376);
        servicesBuilder.add("tnETOS", "tcp", 377);
        servicesBuilder.add("tnETOS", "udp", 377);
        servicesBuilder.add("dsETOS", "tcp", 378);
        servicesBuilder.add("dsETOS", "udp", 378);
        servicesBuilder.add("is99c", "tcp", 379);
        servicesBuilder.add("is99c", "udp", 379);
        servicesBuilder.add("is99s", "tcp", 380);
        servicesBuilder.add("is99s", "udp", 380);
        servicesBuilder.add("hp-collector", "tcp", 381);
        servicesBuilder.add("hp-collector", "udp", 381);
        servicesBuilder.add("hp-managed-node", "tcp", 382);
        servicesBuilder.add("hp-managed-node", "udp", 382);
        servicesBuilder.add("hp-alarm-mgr", "tcp", 383);
        servicesBuilder.add("hp-alarm-mgr", "udp", 383);
        servicesBuilder.add("arns", "tcp", 384);
        servicesBuilder.add("arns", "udp", 384);
        servicesBuilder.add("ibm-app", "tcp", 385);
        servicesBuilder.add("ibm-app", "udp", 385);
        servicesBuilder.add("asa", "tcp", 386);
        servicesBuilder.add("asa", "udp", 386);
        servicesBuilder.add("aurp", "tcp", 387);
        servicesBuilder.add("aurp", "udp", 387);
        servicesBuilder.add("unidata-ldm", "tcp", 388);
        servicesBuilder.add("unidata-ldm", "udp", 388);
        servicesBuilder.add("ldap", "tcp", 389);
        servicesBuilder.add("ldap", "udp", 389);
        servicesBuilder.add("uis", "tcp", 390);
        servicesBuilder.add("uis", "udp", 390);
        servicesBuilder.add("synotics-relay", "tcp", 391);
        servicesBuilder.add("synotics-relay", "udp", 391);
        servicesBuilder.add("synotics-broker", "tcp", 392);
        servicesBuilder.add("synotics-broker", "udp", 392);
        servicesBuilder.add("meta5", "tcp", 393);
        servicesBuilder.add("meta5", "udp", 393);
        servicesBuilder.add("embl-ndt", "tcp", 394);
        servicesBuilder.add("embl-ndt", "udp", 394);
        servicesBuilder.add("netcp", "tcp", 395);
        servicesBuilder.add("netcp", "udp", 395);
        servicesBuilder.add("netware-ip", "tcp", 396);
        servicesBuilder.add("netware-ip", "udp", 396);
        servicesBuilder.add("mptn", "tcp", 397);
        servicesBuilder.add("mptn", "udp", 397);
        servicesBuilder.add("kryptolan", "tcp", 398);
        servicesBuilder.add("kryptolan", "udp", 398);
        servicesBuilder.add("iso-tsap-c2", "tcp", 399);
        servicesBuilder.add("iso-tsap-c2", "udp", 399);
        servicesBuilder.add("work-sol", "tcp", 400);
        servicesBuilder.add("work-sol", "udp", 400);
        servicesBuilder.add("ups", "tcp", 401);
        servicesBuilder.add("ups", "udp", 401);
        servicesBuilder.add("genie", "tcp", 402);
        servicesBuilder.add("genie", "udp", 402);
        servicesBuilder.add("decap", "tcp", 403);
        servicesBuilder.add("decap", "udp", 403);
        servicesBuilder.add("nced", "tcp", 404);
        servicesBuilder.add("nced", "udp", 404);
        servicesBuilder.add("ncld", "tcp", 405);
        servicesBuilder.add("ncld", "udp", 405);
        servicesBuilder.add("imsp", "tcp", 406);
        servicesBuilder.add("imsp", "udp", 406);
        servicesBuilder.add("timbuktu", "tcp", 407);
        servicesBuilder.add("timbuktu", "udp", 407);
        servicesBuilder.add("prm-sm", "tcp", 408);
        servicesBuilder.add("prm-sm", "udp", 408);
        servicesBuilder.add("prm-nm", "tcp", 409);
        servicesBuilder.add("prm-nm", "udp", 409);
        servicesBuilder.add("decladebug", "tcp", 410);
        servicesBuilder.add("decladebug", "udp", 410);
        servicesBuilder.add("rmt", "tcp", 411);
        servicesBuilder.add("rmt", "udp", 411);
        servicesBuilder.add("synoptics-trap", "tcp", 412);
        servicesBuilder.add("synoptics-trap", "udp", 412);
        servicesBuilder.add("smsp", "tcp", 413);
        servicesBuilder.add("smsp", "udp", 413);
        servicesBuilder.add("infoseek", "tcp", 414);
        servicesBuilder.add("infoseek", "udp", 414);
        servicesBuilder.add("bnet", "tcp", 415);
        servicesBuilder.add("bnet", "udp", 415);
        servicesBuilder.add("silverplatter", "tcp", 416);
        servicesBuilder.add("silverplatter", "udp", 416);
        servicesBuilder.add("onmux", "tcp", 417);
        servicesBuilder.add("onmux", "udp", 417);
        servicesBuilder.add("hyper-g", "tcp", 418);
        servicesBuilder.add("hyper-g", "udp", 418);
        servicesBuilder.add("ariel1", "tcp", 419);
        servicesBuilder.add("ariel1", "udp", 419);
        servicesBuilder.add("smpte", "tcp", 420);
        servicesBuilder.add("smpte", "udp", 420);
        servicesBuilder.add("ariel2", "tcp", 421);
        servicesBuilder.add("ariel2", "udp", 421);
        servicesBuilder.add("ariel3", "tcp", 422);
        servicesBuilder.add("ariel3", "udp", 422);
        servicesBuilder.add("opc-job-start", "tcp", 423);
        servicesBuilder.add("opc-job-start", "udp", 423);
        servicesBuilder.add("opc-job-track", "tcp", 424);
        servicesBuilder.add("opc-job-track", "udp", 424);
        servicesBuilder.add("icad-el", "tcp", 425);
        servicesBuilder.add("icad-el", "udp", 425);
        servicesBuilder.add("smartsdp", "tcp", 426);
        servicesBuilder.add("smartsdp", "udp", 426);
        servicesBuilder.add("svrloc", "tcp", 427);
        servicesBuilder.add("svrloc", "udp", 427);
        servicesBuilder.add("ocs_cmu", "tcp", 428);
        servicesBuilder.add("ocs_cmu", "udp", 428);
        servicesBuilder.add("ocs_amu", "tcp", 429);
        servicesBuilder.add("ocs_amu", "udp", 429);
        servicesBuilder.add("utmpsd", "tcp", 430);
        servicesBuilder.add("utmpsd", "udp", 430);
        servicesBuilder.add("utmpcd", "tcp", 431);
        servicesBuilder.add("utmpcd", "udp", 431);
        servicesBuilder.add("iasd", "tcp", 432);
        servicesBuilder.add("iasd", "udp", 432);
        servicesBuilder.add("nnsp", "tcp", 433);
        servicesBuilder.add("nnsp", "udp", 433);
        servicesBuilder.add("mobileip-agent", "tcp", 434);
        servicesBuilder.add("mobileip-agent", "udp", 434);
        servicesBuilder.add("mobilip-mn", "tcp", 435);
        servicesBuilder.add("mobilip-mn", "udp", 435);
        servicesBuilder.add("dna-cml", "tcp", 436);
        servicesBuilder.add("dna-cml", "udp", 436);
        servicesBuilder.add("comscm", "tcp", 437);
        servicesBuilder.add("comscm", "udp", 437);
        servicesBuilder.add("dsfgw", "tcp", 438);
        servicesBuilder.add("dsfgw", "udp", 438);
        servicesBuilder.add("dasp", "tcp", 439);
        servicesBuilder.add("dasp", "udp", 439);
        servicesBuilder.add("sgcp", "tcp", 440);
        servicesBuilder.add("sgcp", "udp", 440);
        servicesBuilder.add("decvms-sysmgt", "tcp", 441);
        servicesBuilder.add("decvms-sysmgt", "udp", 441);
        servicesBuilder.add("cvc_hostd", "tcp", 442);
        servicesBuilder.add("cvc_hostd", "udp", 442);
        servicesBuilder.add("https", "tcp", 443);
        servicesBuilder.add("https", "udp", 443);
        servicesBuilder.add("https/sctp", 443);
        servicesBuilder.add("snpp", "tcp", 444);
        servicesBuilder.add("snpp", "udp", 444);
        servicesBuilder.add("microsoft-ds", "tcp", 445);
        servicesBuilder.add("microsoft-ds", "udp", 445);
        servicesBuilder.add("ddm-rdb", "tcp", 446);
        servicesBuilder.add("ddm-rdb", "udp", 446);
        servicesBuilder.add("ddm-dfm", "tcp", 447);
        servicesBuilder.add("ddm-dfm", "udp", 447);
        servicesBuilder.add("ddm-ssl", "tcp", 448);
        servicesBuilder.add("ddm-ssl", "udp", 448);
        servicesBuilder.add("as-servermap", "tcp", 449);
        servicesBuilder.add("as-servermap", "udp", 449);
        servicesBuilder.add("tserver", "tcp", 450);
        servicesBuilder.add("tserver", "udp", 450);
        servicesBuilder.add("sfs-smp-net", "tcp", 451);
        servicesBuilder.add("sfs-smp-net", "udp", 451);
        servicesBuilder.add("sfs-config", "tcp", 452);
        servicesBuilder.add("sfs-config", "udp", 452);
        servicesBuilder.add("creativeserver", "tcp", 453);
        servicesBuilder.add("creativeserver", "udp", 453);
        servicesBuilder.add("contentserver", "tcp", 454);
        servicesBuilder.add("contentserver", "udp", 454);
        servicesBuilder.add("creativepartnr", "tcp", 455);
        servicesBuilder.add("creativepartnr", "udp", 455);
        servicesBuilder.add("macon-tcp", "tcp", 456);
        servicesBuilder.add("macon-udp", "udp", 456);
        servicesBuilder.add("scohelp", "tcp", 457);
        servicesBuilder.add("scohelp", "udp", 457);
        servicesBuilder.add("appleqtc", "tcp", 458);
        servicesBuilder.add("appleqtc", "udp", 458);
        servicesBuilder.add("ampr-rcmd", "tcp", 459);
        servicesBuilder.add("ampr-rcmd", "udp", 459);
        servicesBuilder.add("skronk", "tcp", 460);
        servicesBuilder.add("skronk", "udp", 460);
        servicesBuilder.add("datasurfsrv", "tcp", 461);
        servicesBuilder.add("datasurfsrv", "udp", 461);
        servicesBuilder.add("datasurfsrvsec", "tcp", 462);
        servicesBuilder.add("datasurfsrvsec", "udp", 462);
        servicesBuilder.add("alpes", "tcp", 463);
        servicesBuilder.add("alpes", "udp", 463);
        servicesBuilder.add("kpasswd", "tcp", 464);
        servicesBuilder.add("kpasswd", "udp", 464);
        servicesBuilder.add("urd", "tcp", 465);
        servicesBuilder.add("igmpv3lite", "udp", 465);
        servicesBuilder.add("digital-vrc", "tcp", 466);
        servicesBuilder.add("digital-vrc", "udp", 466);
        servicesBuilder.add("mylex-mapd", "tcp", 467);
        servicesBuilder.add("mylex-mapd", "udp", 467);
        servicesBuilder.add("photuris", "tcp", 468);
        servicesBuilder.add("photuris", "udp", 468);
        servicesBuilder.add("rcp", "tcp", 469);
        servicesBuilder.add("rcp", "udp", 469);
        servicesBuilder.add("scx-proxy", "tcp", 470);
        servicesBuilder.add("scx-proxy", "udp", 470);
        servicesBuilder.add("mondex", "tcp", 471);
        servicesBuilder.add("mondex", "udp", 471);
        servicesBuilder.add("ljk-login", "tcp", 472);
        servicesBuilder.add("ljk-login", "udp", 472);
        servicesBuilder.add("hybrid-pop", "tcp", 473);
        servicesBuilder.add("hybrid-pop", "udp", 473);
        servicesBuilder.add("tn-tl-w1", "tcp", 474);
        servicesBuilder.add("tn-tl-w2", "udp", 474);
        servicesBuilder.add("tcpnethaspsrv", "tcp", 475);
        servicesBuilder.add("tcpnethaspsrv", "udp", 475);
        servicesBuilder.add("tn-tl-fd1", "tcp", 476);
        servicesBuilder.add("tn-tl-fd1", "udp", 476);
        servicesBuilder.add("ss7ns", "tcp", 477);
        servicesBuilder.add("ss7ns", "udp", 477);
        servicesBuilder.add("spsc", "tcp", 478);
        servicesBuilder.add("spsc", "udp", 478);
        servicesBuilder.add("iafserver", "tcp", 479);
        servicesBuilder.add("iafserver", "udp", 479);
        servicesBuilder.add("iafdbase", "tcp", 480);
        servicesBuilder.add("iafdbase", "udp", 480);
        servicesBuilder.add("ph", "tcp", 481);
        servicesBuilder.add("ph", "udp", 481);
        servicesBuilder.add("bgs-nsi", "tcp", 482);
        servicesBuilder.add("bgs-nsi", "udp", 482);
        servicesBuilder.add("ulpnet", "tcp", 483);
        servicesBuilder.add("ulpnet", "udp", 483);
        servicesBuilder.add("integra-sme", "tcp", 484);
        servicesBuilder.add("integra-sme", "udp", 484);
        servicesBuilder.add("powerburst", "tcp", 485);
        servicesBuilder.add("powerburst", "udp", 485);
        servicesBuilder.add("avian", "tcp", 486);
        servicesBuilder.add("avian", "udp", 486);
        servicesBuilder.add("saft", "tcp", 487);
        servicesBuilder.add("saft", "udp", 487);
        servicesBuilder.add("gss-http", "tcp", 488);
        servicesBuilder.add("gss-http", "udp", 488);
        servicesBuilder.add("nest-protocol", "tcp", 489);
        servicesBuilder.add("nest-protocol", "udp", 489);
        servicesBuilder.add("micom-pfs", "tcp", 490);
        servicesBuilder.add("micom-pfs", "udp", 490);
        servicesBuilder.add("go-login", "tcp", 491);
        servicesBuilder.add("go-login", "udp", 491);
        servicesBuilder.add("ticf-1", "tcp", 492);
        servicesBuilder.add("ticf-1", "udp", 492);
        servicesBuilder.add("ticf-2", "tcp", 493);
        servicesBuilder.add("ticf-2", "udp", 493);
        servicesBuilder.add("pov-ray", "tcp", 494);
        servicesBuilder.add("pov-ray", "udp", 494);
        servicesBuilder.add("intecourier", "tcp", 495);
        servicesBuilder.add("intecourier", "udp", 495);
        servicesBuilder.add("pim-rp-disc", "tcp", 496);
        servicesBuilder.add("pim-rp-disc", "udp", 496);
        servicesBuilder.add("dantz", "tcp", 497);
        servicesBuilder.add("dantz", "udp", 497);
        servicesBuilder.add("siam", "tcp", 498);
        servicesBuilder.add("siam", "udp", 498);
        servicesBuilder.add("iso-ill", "tcp", 499);
        servicesBuilder.add("iso-ill", "udp", 499);
        servicesBuilder.add("isakmp", "tcp", 500);
        servicesBuilder.add("isakmp", "udp", 500);
        servicesBuilder.add("stmf", "tcp", 501);
        servicesBuilder.add("stmf", "udp", 501);
        servicesBuilder.add("asa-appl-proto", "tcp", 502);
        servicesBuilder.add("asa-appl-proto", "udp", 502);
        servicesBuilder.add("intrinsa", "tcp", 503);
        servicesBuilder.add("intrinsa", "udp", 503);
        servicesBuilder.add("citadel", "tcp", 504);
        servicesBuilder.add("citadel", "udp", 504);
        servicesBuilder.add("mailbox-lm", "tcp", 505);
        servicesBuilder.add("mailbox-lm", "udp", 505);
        servicesBuilder.add("ohimsrv", "tcp", 506);
        servicesBuilder.add("ohimsrv", "udp", 506);
        servicesBuilder.add("crs", "tcp", 507);
        servicesBuilder.add("crs", "udp", 507);
        servicesBuilder.add("xvttp", "tcp", 508);
        servicesBuilder.add("xvttp", "udp", 508);
        servicesBuilder.add("snare", "tcp", 509);
        servicesBuilder.add("snare", "udp", 509);
        servicesBuilder.add("fcp", "tcp", 510);
        servicesBuilder.add("fcp", "udp", 510);
        servicesBuilder.add("passgo", "tcp", 511);
        servicesBuilder.add("passgo", "udp", 511);
        servicesBuilder.add("exec", "tcp", 512);
        servicesBuilder.add("comsat", "udp", 512);
        servicesBuilder.add("biff", "udp", 512);
        servicesBuilder.add("login", "tcp", 513);
        servicesBuilder.add("who", "udp", 513);
        servicesBuilder.add("shell", "tcp", 514);
        servicesBuilder.add("syslog", "udp", 514);
        servicesBuilder.add("printer", "tcp", 515);
        servicesBuilder.add("printer", "udp", 515);
        servicesBuilder.add("videotex", "tcp", 516);
        servicesBuilder.add("videotex", "udp", 516);
        servicesBuilder.add("talk", "tcp", 517);
        servicesBuilder.add("talk", "udp", 517);
        servicesBuilder.add("ntalk", "tcp", 518);
        servicesBuilder.add("ntalk", "udp", 518);
        servicesBuilder.add("utime", "tcp", 519);
        servicesBuilder.add("utime", "udp", 519);
        servicesBuilder.add("efs", "tcp", 520);
        servicesBuilder.add("router", "udp", 520);
        servicesBuilder.add("ripng", "tcp", 521);
        servicesBuilder.add("ripng", "udp", 521);
        servicesBuilder.add("ulp", "tcp", 522);
        servicesBuilder.add("ulp", "udp", 522);
        servicesBuilder.add("ibm-db2", "tcp", 523);
        servicesBuilder.add("ibm-db2", "udp", 523);
        servicesBuilder.add("ncp", "tcp", 524);
        servicesBuilder.add("ncp", "udp", 524);
        servicesBuilder.add("timed", "tcp", 525);
        servicesBuilder.add("timed", "udp", 525);
        servicesBuilder.add("tempo", "tcp", 526);
        servicesBuilder.add("tempo", "udp", 526);
        servicesBuilder.add("stx", "tcp", 527);
        servicesBuilder.add("stx", "udp", 527);
        servicesBuilder.add("custix", "tcp", 528);
        servicesBuilder.add("custix", "udp", 528);
        servicesBuilder.add("irc-serv", "tcp", 529);
        servicesBuilder.add("irc-serv", "udp", 529);
        servicesBuilder.add("courier", "tcp", 530);
        servicesBuilder.add("courier", "udp", 530);
        servicesBuilder.add("conference", "tcp", 531);
        servicesBuilder.add("conference", "udp", 531);
        servicesBuilder.add("netnews", "tcp", 532);
        servicesBuilder.add("netnews", "udp", 532);
        servicesBuilder.add("netwall", "tcp", 533);
        servicesBuilder.add("netwall", "udp", 533);
        servicesBuilder.add("windream", "tcp", 534);
        servicesBuilder.add("windream", "udp", 534);
        servicesBuilder.add("iiop", "tcp", 535);
        servicesBuilder.add("iiop", "udp", 535);
        servicesBuilder.add("opalis-rdv", "tcp", 536);
        servicesBuilder.add("opalis-rdv", "udp", 536);
        servicesBuilder.add("nmsp", "tcp", 537);
        servicesBuilder.add("nmsp", "udp", 537);
        servicesBuilder.add("gdomap", "tcp", 538);
        servicesBuilder.add("gdomap", "udp", 538);
        servicesBuilder.add("apertus-ldp", "tcp", 539);
        servicesBuilder.add("apertus-ldp", "udp", 539);
        servicesBuilder.add("uucp", "tcp", 540);
        servicesBuilder.add("uucp", "udp", 540);
        servicesBuilder.add("uucp-rlogin", "tcp", 541);
        servicesBuilder.add("uucp-rlogin", "udp", 541);
        servicesBuilder.add("commerce", "tcp", 542);
        servicesBuilder.add("commerce", "udp", 542);
        servicesBuilder.add("klogin", "tcp", 543);
        servicesBuilder.add("klogin", "udp", 543);
        servicesBuilder.add("kshell", "tcp", 544);
        servicesBuilder.add("kshell", "udp", 544);
        servicesBuilder.add("appleqtcsrvr", "tcp", 545);
        servicesBuilder.add("appleqtcsrvr", "udp", 545);
        servicesBuilder.add("dhcpv6-client", "tcp", 546);
        servicesBuilder.add("dhcpv6-client", "udp", 546);
        servicesBuilder.add("dhcpv6-server", "tcp", 547);
        servicesBuilder.add("dhcpv6-server", "udp", 547);
        servicesBuilder.add("afpovertcp", "tcp", 548);
        servicesBuilder.add("afpovertcp", "udp", 548);
        servicesBuilder.add("idfp", "tcp", 549);
        servicesBuilder.add("idfp", "udp", 549);
        servicesBuilder.add("new-rwho", "tcp", 550);
        servicesBuilder.add("new-rwho", "udp", 550);
        servicesBuilder.add("cybercash", "tcp", 551);
        servicesBuilder.add("cybercash", "udp", 551);
        servicesBuilder.add("devshr-nts", "tcp", 552);
        servicesBuilder.add("devshr-nts", "udp", 552);
        servicesBuilder.add("pirp", "tcp", 553);
        servicesBuilder.add("pirp", "udp", 553);
        servicesBuilder.add("rtsp", "tcp", 554);
        servicesBuilder.add("rtsp", "udp", 554);
        servicesBuilder.add("dsf", "tcp", 555);
        servicesBuilder.add("dsf", "udp", 555);
        servicesBuilder.add("remotefs", "tcp", 556);
        servicesBuilder.add("remotefs", "udp", 556);
        servicesBuilder.add("openvms-sysipc", "tcp", 557);
        servicesBuilder.add("openvms-sysipc", "udp", 557);
        servicesBuilder.add("sdnskmp", "tcp", 558);
        servicesBuilder.add("sdnskmp", "udp", 558);
        servicesBuilder.add("teedtap", "tcp", 559);
        servicesBuilder.add("teedtap", "udp", 559);
        servicesBuilder.add("rmonitor", "tcp", 560);
        servicesBuilder.add("rmonitor", "udp", 560);
        servicesBuilder.add("monitor", "tcp", 561);
        servicesBuilder.add("monitor", "udp", 561);
        servicesBuilder.add("chshell", "tcp", 562);
        servicesBuilder.add("chshell", "udp", 562);
        servicesBuilder.add("nntps", "tcp", 563);
        servicesBuilder.add("nntps", "udp", 563);
        servicesBuilder.add("9pfs", "tcp", 564);
        servicesBuilder.add("9pfs", "udp", 564);
        servicesBuilder.add("whoami", "tcp", 565);
        servicesBuilder.add("whoami", "udp", 565);
        servicesBuilder.add("streettalk", "tcp", 566);
        servicesBuilder.add("streettalk", "udp", 566);
        servicesBuilder.add("banyan-rpc", "tcp", 567);
        servicesBuilder.add("banyan-rpc", "udp", 567);
        servicesBuilder.add("ms-shuttle", "tcp", 568);
        servicesBuilder.add("ms-shuttle", "udp", 568);
        servicesBuilder.add("ms-rome", "tcp", 569);
        servicesBuilder.add("ms-rome", "udp", 569);
        servicesBuilder.add("meter", "tcp", 570);
        servicesBuilder.add("meter", "udp", 570);
        servicesBuilder.add("meter", "tcp", 571);
        servicesBuilder.add("meter", "udp", 571);
        servicesBuilder.add("sonar", "tcp", 572);
        servicesBuilder.add("sonar", "udp", 572);
        servicesBuilder.add("banyan-vip", "tcp", 573);
        servicesBuilder.add("banyan-vip", "udp", 573);
        servicesBuilder.add("ftp-agent", "tcp", 574);
        servicesBuilder.add("ftp-agent", "udp", 574);
        servicesBuilder.add("vemmi", "tcp", 575);
        servicesBuilder.add("vemmi", "udp", 575);
        servicesBuilder.add("ipcd", "tcp", 576);
        servicesBuilder.add("ipcd", "udp", 576);
        servicesBuilder.add("vnas", "tcp", 577);
        servicesBuilder.add("vnas", "udp", 577);
        servicesBuilder.add("ipdd", "tcp", 578);
        servicesBuilder.add("ipdd", "udp", 578);
        servicesBuilder.add("decbsrv", "tcp", 579);
        servicesBuilder.add("decbsrv", "udp", 579);
        servicesBuilder.add("sntp-heartbeat", "tcp", 580);
        servicesBuilder.add("sntp-heartbeat", "udp", 580);
        servicesBuilder.add("bdp", "tcp", 581);
        servicesBuilder.add("bdp", "udp", 581);
        servicesBuilder.add("scc-security", "tcp", 582);
        servicesBuilder.add("scc-security", "udp", 582);
        servicesBuilder.add("philips-vc", "tcp", 583);
        servicesBuilder.add("philips-vc", "udp", 583);
        servicesBuilder.add("keyserver", "tcp", 584);
        servicesBuilder.add("keyserver", "udp", 584);
        servicesBuilder.add("password-chg", "tcp", 586);
        servicesBuilder.add("password-chg", "udp", 586);
        servicesBuilder.add("submission", "tcp", 587);
        servicesBuilder.add("submission", "udp", 587);
        servicesBuilder.add("cal", "tcp", 588);
        servicesBuilder.add("cal", "udp", 588);
        servicesBuilder.add("eyelink", "tcp", 589);
        servicesBuilder.add("eyelink", "udp", 589);
        servicesBuilder.add("tns-cml", "tcp", 590);
        servicesBuilder.add("tns-cml", "udp", 590);
        servicesBuilder.add("http-alt", "tcp", 591);
        servicesBuilder.add("http-alt", "udp", 591);
        servicesBuilder.add("eudora-set", "tcp", 592);
        servicesBuilder.add("eudora-set", "udp", 592);
        servicesBuilder.add("http-rpc-epmap", "tcp", 593);
        servicesBuilder.add("http-rpc-epmap", "udp", 593);
        servicesBuilder.add("tpip", "tcp", 594);
        servicesBuilder.add("tpip", "udp", 594);
        servicesBuilder.add("cab-protocol", "tcp", 595);
        servicesBuilder.add("cab-protocol", "udp", 595);
        servicesBuilder.add("smsd", "tcp", 596);
        servicesBuilder.add("smsd", "udp", 596);
        servicesBuilder.add("ptcnameservice", "tcp", 597);
        servicesBuilder.add("ptcnameservice", "udp", 597);
        servicesBuilder.add("sco-websrvrmg3", "tcp", 598);
        servicesBuilder.add("sco-websrvrmg3", "udp", 598);
        servicesBuilder.add("acp", "tcp", 599);
        servicesBuilder.add("acp", "udp", 599);
        servicesBuilder.add("ipcserver", "tcp", 600);
        servicesBuilder.add("ipcserver", "udp", 600);
        servicesBuilder.add("syslog-conn", "tcp", 601);
        servicesBuilder.add("syslog-conn", "udp", 601);
        servicesBuilder.add("xmlrpc-beep", "tcp", 602);
        servicesBuilder.add("xmlrpc-beep", "udp", 602);
        servicesBuilder.add("idxp", "tcp", 603);
        servicesBuilder.add("idxp", "udp", 603);
        servicesBuilder.add("tunnel", "tcp", 604);
        servicesBuilder.add("tunnel", "udp", 604);
        servicesBuilder.add("soap-beep", "tcp", 605);
        servicesBuilder.add("soap-beep", "udp", 605);
        servicesBuilder.add("urm", "tcp", 606);
        servicesBuilder.add("urm", "udp", 606);
        servicesBuilder.add("nqs", "tcp", 607);
        servicesBuilder.add("nqs", "udp", 607);
        servicesBuilder.add("sift-uft", "tcp", 608);
        servicesBuilder.add("sift-uft", "udp", 608);
        servicesBuilder.add("npmp-trap", "tcp", 609);
        servicesBuilder.add("npmp-trap", "udp", 609);
        servicesBuilder.add("npmp-local", "tcp", 610);
        servicesBuilder.add("npmp-local", "udp", 610);
        servicesBuilder.add("npmp-gui", "tcp", 611);
        servicesBuilder.add("npmp-gui", "udp", 611);
        servicesBuilder.add("hmmp-ind", "tcp", 612);
        servicesBuilder.add("hmmp-ind", "udp", 612);
        servicesBuilder.add("hmmp-op", "tcp", 613);
        servicesBuilder.add("hmmp-op", "udp", 613);
        servicesBuilder.add("sshell", "tcp", 614);
        servicesBuilder.add("sshell", "udp", 614);
        servicesBuilder.add("sco-inetmgr", "tcp", 615);
        servicesBuilder.add("sco-inetmgr", "udp", 615);
        servicesBuilder.add("sco-sysmgr", "tcp", 616);
        servicesBuilder.add("sco-sysmgr", "udp", 616);
        servicesBuilder.add("sco-dtmgr", "tcp", 617);
        servicesBuilder.add("sco-dtmgr", "udp", 617);
        servicesBuilder.add("dei-icda", "tcp", 618);
        servicesBuilder.add("dei-icda", "udp", 618);
        servicesBuilder.add("compaq-evm", "tcp", 619);
        servicesBuilder.add("compaq-evm", "udp", 619);
        servicesBuilder.add("sco-websrvrmgr", "tcp", 620);
        servicesBuilder.add("sco-websrvrmgr", "udp", 620);
        servicesBuilder.add("escp-ip", "tcp", 621);
        servicesBuilder.add("escp-ip", "udp", 621);
        servicesBuilder.add("collaborator", "tcp", 622);
        servicesBuilder.add("collaborator", "udp", 622);
        servicesBuilder.add("oob-ws-http", "tcp", 623);
        servicesBuilder.add("asf-rmcp", "udp", 623);
        servicesBuilder.add("cryptoadmin", "tcp", 624);
        servicesBuilder.add("cryptoadmin", "udp", 624);
        servicesBuilder.add("dec_dlm", "tcp", 625);
        servicesBuilder.add("dec_dlm", "udp", 625);
        servicesBuilder.add("asia", "tcp", 626);
        servicesBuilder.add("asia", "udp", 626);
        servicesBuilder.add("passgo-tivoli", "tcp", 627);
        servicesBuilder.add("passgo-tivoli", "udp", 627);
        servicesBuilder.add("qmqp", "tcp", 628);
        servicesBuilder.add("qmqp", "udp", 628);
        servicesBuilder.add("3com-amp3", "tcp", 629);
        servicesBuilder.add("3com-amp3", "udp", 629);
        servicesBuilder.add("rda", "tcp", 630);
        servicesBuilder.add("rda", "udp", 630);
        servicesBuilder.add("ipp", "tcp", 631);
        servicesBuilder.add("ipp", "udp", 631);
        servicesBuilder.add("bmpp", "tcp", 632);
        servicesBuilder.add("bmpp", "udp", 632);
        servicesBuilder.add("servstat", "tcp", 633);
        servicesBuilder.add("servstat", "udp", 633);
        servicesBuilder.add("ginad", "tcp", 634);
        servicesBuilder.add("ginad", "udp", 634);
        servicesBuilder.add("rlzdbase", "tcp", 635);
        servicesBuilder.add("rlzdbase", "udp", 635);
        servicesBuilder.add("ldaps", "tcp", 636);
        servicesBuilder.add("ldaps", "udp", 636);
        servicesBuilder.add("lanserver", "tcp", 637);
        servicesBuilder.add("lanserver", "udp", 637);
        servicesBuilder.add("mcns-sec", "tcp", 638);
        servicesBuilder.add("mcns-sec", "udp", 638);
        servicesBuilder.add("msdp", "tcp", 639);
        servicesBuilder.add("msdp", "udp", 639);
        servicesBuilder.add("entrust-sps", "tcp", 640);
        servicesBuilder.add("entrust-sps", "udp", 640);
        servicesBuilder.add("repcmd", "tcp", 641);
        servicesBuilder.add("repcmd", "udp", 641);
        servicesBuilder.add("esro-emsdp", "tcp", 642);
        servicesBuilder.add("esro-emsdp", "udp", 642);
        servicesBuilder.add("sanity", "tcp", 643);
        servicesBuilder.add("sanity", "udp", 643);
        servicesBuilder.add("dwr", "tcp", 644);
        servicesBuilder.add("dwr", "udp", 644);
        servicesBuilder.add("pssc", "tcp", 645);
        servicesBuilder.add("pssc", "udp", 645);
        servicesBuilder.add("ldp", "tcp", 646);
        servicesBuilder.add("ldp", "udp", 646);
        servicesBuilder.add("dhcp-failover", "tcp", 647);
        servicesBuilder.add("dhcp-failover", "udp", 647);
        servicesBuilder.add("rrp", "tcp", 648);
        servicesBuilder.add("rrp", "udp", 648);
        servicesBuilder.add("cadview-3d", "tcp", 649);
        servicesBuilder.add("cadview-3d", "udp", 649);
        servicesBuilder.add("obex", "tcp", 650);
        servicesBuilder.add("obex", "udp", 650);
        servicesBuilder.add("ieee-mms", "tcp", 651);
        servicesBuilder.add("ieee-mms", "udp", 651);
        servicesBuilder.add("hello-port", "tcp", 652);
        servicesBuilder.add("hello-port", "udp", 652);
        servicesBuilder.add("repscmd", "tcp", 653);
        servicesBuilder.add("repscmd", "udp", 653);
        servicesBuilder.add("aodv", "tcp", 654);
        servicesBuilder.add("aodv", "udp", 654);
        servicesBuilder.add("tinc", "tcp", 655);
        servicesBuilder.add("tinc", "udp", 655);
        servicesBuilder.add("spmp", "tcp", 656);
        servicesBuilder.add("spmp", "udp", 656);
        servicesBuilder.add("rmc", "tcp", 657);
        servicesBuilder.add("rmc", "udp", 657);
        servicesBuilder.add("tenfold", "tcp", 658);
        servicesBuilder.add("tenfold", "udp", 658);
        servicesBuilder.add("mac-srvr-admin", "tcp", 660);
        servicesBuilder.add("mac-srvr-admin", "udp", 660);
        servicesBuilder.add("hap", "tcp", 661);
        servicesBuilder.add("hap", "udp", 661);
        servicesBuilder.add("pftp", "tcp", 662);
        servicesBuilder.add("pftp", "udp", 662);
        servicesBuilder.add("purenoise", "tcp", 663);
        servicesBuilder.add("purenoise", "udp", 663);
        servicesBuilder.add("oob-ws-https", "tcp", 664);
        servicesBuilder.add("asf-secure-rmcp", "udp", 664);
        servicesBuilder.add("sun-dr", "tcp", 665);
        servicesBuilder.add("sun-dr", "udp", 665);
        servicesBuilder.add("mdqs", "tcp", 666);
        servicesBuilder.add("mdqs", "udp", 666);
        servicesBuilder.add("doom", "tcp", 666);
        servicesBuilder.add("doom", "udp", 666);
        servicesBuilder.add("disclose", "tcp", 667);
        servicesBuilder.add("disclose", "udp", 667);
        servicesBuilder.add("mecomm", "tcp", 668);
        servicesBuilder.add("mecomm", "udp", 668);
        servicesBuilder.add("meregister", "tcp", 669);
        servicesBuilder.add("meregister", "udp", 669);
        servicesBuilder.add("vacdsm-sws", "tcp", 670);
        servicesBuilder.add("vacdsm-sws", "udp", 670);
        servicesBuilder.add("vacdsm-app", "tcp", 671);
        servicesBuilder.add("vacdsm-app", "udp", 671);
        servicesBuilder.add("vpps-qua", "tcp", 672);
        servicesBuilder.add("vpps-qua", "udp", 672);
        servicesBuilder.add("cimplex", "tcp", 673);
        servicesBuilder.add("cimplex", "udp", 673);
        servicesBuilder.add("acap", "tcp", 674);
        servicesBuilder.add("acap", "udp", 674);
        servicesBuilder.add("dctp", "tcp", 675);
        servicesBuilder.add("dctp", "udp", 675);
        servicesBuilder.add("vpps-via", "tcp", 676);
        servicesBuilder.add("vpps-via", "udp", 676);
        servicesBuilder.add("vpp", "tcp", 677);
        servicesBuilder.add("vpp", "udp", 677);
        servicesBuilder.add("ggf-ncp", "tcp", 678);
        servicesBuilder.add("ggf-ncp", "udp", 678);
        servicesBuilder.add("mrm", "tcp", 679);
        servicesBuilder.add("mrm", "udp", 679);
        servicesBuilder.add("entrust-aaas", "tcp", 680);
        servicesBuilder.add("entrust-aaas", "udp", 680);
        servicesBuilder.add("entrust-aams", "tcp", 681);
        servicesBuilder.add("entrust-aams", "udp", 681);
        servicesBuilder.add("xfr", "tcp", 682);
        servicesBuilder.add("xfr", "udp", 682);
        servicesBuilder.add("corba-iiop", "tcp", 683);
        servicesBuilder.add("corba-iiop", "udp", 683);
        servicesBuilder.add("corba-iiop-ssl", "tcp", 684);
        servicesBuilder.add("corba-iiop-ssl", "udp", 684);
        servicesBuilder.add("mdc-portmapper", "tcp", 685);
        servicesBuilder.add("mdc-portmapper", "udp", 685);
        servicesBuilder.add("hcp-wismar", "tcp", 686);
        servicesBuilder.add("hcp-wismar", "udp", 686);
        servicesBuilder.add("asipregistry", "tcp", 687);
        servicesBuilder.add("asipregistry", "udp", 687);
        servicesBuilder.add("realm-rusd", "tcp", 688);
        servicesBuilder.add("realm-rusd", "udp", 688);
        servicesBuilder.add("nmap", "tcp", 689);
        servicesBuilder.add("nmap", "udp", 689);
        servicesBuilder.add("vatp", "tcp", 690);
        servicesBuilder.add("vatp", "udp", 690);
        servicesBuilder.add("msexch-routing", "tcp", 691);
        servicesBuilder.add("msexch-routing", "udp", 691);
        servicesBuilder.add("hyperwave-isp", "tcp", 692);
        servicesBuilder.add("hyperwave-isp", "udp", 692);
        servicesBuilder.add("connendp", "tcp", 693);
        servicesBuilder.add("connendp", "udp", 693);
        servicesBuilder.add("ha-cluster", "tcp", 694);
        servicesBuilder.add("ha-cluster", "udp", 694);
        servicesBuilder.add("ieee-mms-ssl", "tcp", 695);
        servicesBuilder.add("ieee-mms-ssl", "udp", 695);
        servicesBuilder.add("rushd", "tcp", 696);
        servicesBuilder.add("rushd", "udp", 696);
        servicesBuilder.add("uuidgen", "tcp", 697);
        servicesBuilder.add("uuidgen", "udp", 697);
        servicesBuilder.add("olsr", "tcp", 698);
        servicesBuilder.add("olsr", "udp", 698);
        servicesBuilder.add("accessnetwork", "tcp", 699);
        servicesBuilder.add("accessnetwork", "udp", 699);
        servicesBuilder.add("epp", "tcp", 700);
        servicesBuilder.add("epp", "udp", 700);
        servicesBuilder.add("lmp", "tcp", 701);
        servicesBuilder.add("lmp", "udp", 701);
        servicesBuilder.add("iris-beep", "tcp", 702);
        servicesBuilder.add("iris-beep", "udp", 702);
        servicesBuilder.add("elcsd", "tcp", 704);
        servicesBuilder.add("elcsd", "udp", 704);
        servicesBuilder.add("agentx", "tcp", 705);
        servicesBuilder.add("agentx", "udp", 705);
        servicesBuilder.add("silc", "tcp", 706);
        servicesBuilder.add("silc", "udp", 706);
        servicesBuilder.add("borland-dsj", "tcp", 707);
        servicesBuilder.add("borland-dsj", "udp", 707);
        servicesBuilder.add("entrust-kmsh", "tcp", 709);
        servicesBuilder.add("entrust-kmsh", "udp", 709);
        servicesBuilder.add("entrust-ash", "tcp", 710);
        servicesBuilder.add("entrust-ash", "udp", 710);
        servicesBuilder.add("cisco-tdp", "tcp", 711);
        servicesBuilder.add("cisco-tdp", "udp", 711);
        servicesBuilder.add("tbrpf", "tcp", 712);
        servicesBuilder.add("tbrpf", "udp", 712);
        servicesBuilder.add("iris-xpc", "tcp", 713);
        servicesBuilder.add("iris-xpc", "udp", 713);
        servicesBuilder.add("iris-xpcs", "tcp", 714);
        servicesBuilder.add("iris-xpcs", "udp", 714);
        servicesBuilder.add("iris-lwz", "tcp", 715);
        servicesBuilder.add("iris-lwz", "udp", 715);
        servicesBuilder.add("pana", "udp", 716);
        servicesBuilder.add("netviewdm1", "tcp", 729);
        servicesBuilder.add("netviewdm1", "udp", 729);
        servicesBuilder.add("netviewdm2", "tcp", 730);
        servicesBuilder.add("netviewdm2", "udp", 730);
        servicesBuilder.add("netviewdm3", "tcp", 731);
        servicesBuilder.add("netviewdm3", "udp", 731);
        servicesBuilder.add("netgw", "tcp", 741);
        servicesBuilder.add("netgw", "udp", 741);
        servicesBuilder.add("netrcs", "tcp", 742);
        servicesBuilder.add("netrcs", "udp", 742);
        servicesBuilder.add("flexlm", "tcp", 744);
        servicesBuilder.add("flexlm", "udp", 744);
        servicesBuilder.add("fujitsu-dev", "tcp", 747);
        servicesBuilder.add("fujitsu-dev", "udp", 747);
        servicesBuilder.add("ris-cm", "tcp", 748);
        servicesBuilder.add("ris-cm", "udp", 748);
        servicesBuilder.add("kerberos-adm", "tcp", 749);
        servicesBuilder.add("kerberos-adm", "udp", 749);
        servicesBuilder.add("rfile", "tcp", 750);
        servicesBuilder.add("loadav", "udp", 750);
        servicesBuilder.add("kerberos-iv", "udp", 750);
        servicesBuilder.add("pump", "tcp", 751);
        servicesBuilder.add("pump", "udp", 751);
        servicesBuilder.add("qrh", "tcp", 752);
        servicesBuilder.add("qrh", "udp", 752);
        servicesBuilder.add("rrh", "tcp", 753);
        servicesBuilder.add("rrh", "udp", 753);
        servicesBuilder.add("tell", "tcp", 754);
        servicesBuilder.add("tell", "udp", 754);
        servicesBuilder.add("nlogin", "tcp", 758);
        servicesBuilder.add("nlogin", "udp", 758);
        servicesBuilder.add("con", "tcp", 759);
        servicesBuilder.add("con", "udp", 759);
        servicesBuilder.add("ns", "tcp", 760);
        servicesBuilder.add("ns", "udp", 760);
        servicesBuilder.add("rxe", "tcp", 761);
        servicesBuilder.add("rxe", "udp", 761);
        servicesBuilder.add("quotad", "tcp", 762);
        servicesBuilder.add("quotad", "udp", 762);
        servicesBuilder.add("cycleserv", "tcp", 763);
        servicesBuilder.add("cycleserv", "udp", 763);
        servicesBuilder.add("omserv", "tcp", 764);
        servicesBuilder.add("omserv", "udp", 764);
        servicesBuilder.add("webster", "tcp", 765);
        servicesBuilder.add("webster", "udp", 765);
        servicesBuilder.add("phonebook", "tcp", 767);
        servicesBuilder.add("phonebook", "udp", 767);
        servicesBuilder.add("vid", "tcp", 769);
        servicesBuilder.add("vid", "udp", 769);
        servicesBuilder.add("cadlock", "tcp", 770);
        servicesBuilder.add("cadlock", "udp", 770);
        servicesBuilder.add("rtip", "tcp", 771);
        servicesBuilder.add("rtip", "udp", 771);
        servicesBuilder.add("cycleserv2", "tcp", 772);
        servicesBuilder.add("cycleserv2", "udp", 772);
        servicesBuilder.add("submit", "tcp", 773);
        servicesBuilder.add("notify", "udp", 773);
        servicesBuilder.add("rpasswd", "tcp", 774);
        servicesBuilder.add("acmaint_dbd", "udp", 774);
        servicesBuilder.add("entomb", "tcp", 775);
        servicesBuilder.add("acmaint_transd", "udp", 775);
        servicesBuilder.add("wpages", "tcp", 776);
        servicesBuilder.add("wpages", "udp", 776);
        servicesBuilder.add("multiling-http", "tcp", 777);
        servicesBuilder.add("multiling-http", "udp", 777);
        servicesBuilder.add("wpgs", "tcp", 780);
        servicesBuilder.add("wpgs", "udp", 780);
        servicesBuilder.add("mdbs_daemon", "tcp", 800);
        servicesBuilder.add("mdbs_daemon", "udp", 800);
        servicesBuilder.add("device", "tcp", 801);
        servicesBuilder.add("device", "udp", 801);
        servicesBuilder.add("fcp-udp", "tcp", 810);
        servicesBuilder.add("fcp-udp", "udp", 810);
        servicesBuilder.add("itm-mcell-s", "tcp", 828);
        servicesBuilder.add("itm-mcell-s", "udp", 828);
        servicesBuilder.add("pkix-3-ca-ra", "tcp", 829);
        servicesBuilder.add("pkix-3-ca-ra", "udp", 829);
        servicesBuilder.add("netconf-ssh", "tcp", 830);
        servicesBuilder.add("netconf-ssh", "udp", 830);
        servicesBuilder.add("netconf-beep", "tcp", 831);
        servicesBuilder.add("netconf-beep", "udp", 831);
        servicesBuilder.add("netconfsoaphttp", "tcp", 832);
        servicesBuilder.add("netconfsoaphttp", "udp", 832);
        servicesBuilder.add("netconfsoapbeep", "tcp", 833);
        servicesBuilder.add("netconfsoapbeep", "udp", 833);
        servicesBuilder.add("dhcp-failover2", "tcp", 847);
        servicesBuilder.add("dhcp-failover2", "udp", 847);
        servicesBuilder.add("gdoi", "tcp", 848);
        servicesBuilder.add("gdoi", "udp", 848);
        servicesBuilder.add("iscsi", "tcp", 860);
        servicesBuilder.add("iscsi", "udp", 860);
        servicesBuilder.add("owamp-control", "tcp", 861);
        servicesBuilder.add("owamp-control", "udp", 861);
        servicesBuilder.add("rsync", "tcp", 873);
        servicesBuilder.add("rsync", "udp", 873);
        servicesBuilder.add("iclcnet-locate", "tcp", 886);
        servicesBuilder.add("iclcnet-locate", "udp", 886);
        servicesBuilder.add("iclcnet_svinfo", "tcp", 887);
        servicesBuilder.add("iclcnet_svinfo", "udp", 887);
        servicesBuilder.add("accessbuilder", "tcp", 888);
        servicesBuilder.add("accessbuilder", "udp", 888);
        servicesBuilder.add("cddbp", "tcp", 888);
        servicesBuilder.add("omginitialrefs", "tcp", 900);
        servicesBuilder.add("omginitialrefs", "udp", 900);
        servicesBuilder.add("smpnameres", "tcp", 901);
        servicesBuilder.add("smpnameres", "udp", 901);
        servicesBuilder.add("ideafarm-door", "tcp", 902);
        servicesBuilder.add("ideafarm-door", "udp", 902);
        servicesBuilder.add("ideafarm-panic", "tcp", 903);
        servicesBuilder.add("ideafarm-panic", "udp", 903);
        servicesBuilder.add("kink", "tcp", 910);
        servicesBuilder.add("kink", "udp", 910);
        servicesBuilder.add("xact-backup", "tcp", 911);
        servicesBuilder.add("xact-backup", "udp", 911);
        servicesBuilder.add("apex-mesh", "tcp", 912);
        servicesBuilder.add("apex-mesh", "udp", 912);
        servicesBuilder.add("apex-edge", "tcp", 913);
        servicesBuilder.add("apex-edge", "udp", 913);
        servicesBuilder.add("ftps-data", "tcp", 989);
        servicesBuilder.add("ftps-data", "udp", 989);
        servicesBuilder.add("ftps", "tcp", 990);
        servicesBuilder.add("ftps", "udp", 990);
        servicesBuilder.add("nas", "tcp", 991);
        servicesBuilder.add("nas", "udp", 991);
        servicesBuilder.add("telnets", "tcp", 992);
        servicesBuilder.add("telnets", "udp", 992);
        servicesBuilder.add("imaps", "tcp", 993);
        servicesBuilder.add("imaps", "udp", 993);
        servicesBuilder.add("ircs", "tcp", 994);
        servicesBuilder.add("ircs", "udp", 994);
        servicesBuilder.add("pop3s", "tcp", 995);
        servicesBuilder.add("pop3s", "udp", 995);
        servicesBuilder.add("vsinet", "tcp", 996);
        servicesBuilder.add("vsinet", "udp", 996);
        servicesBuilder.add("maitrd", "tcp", 997);
        servicesBuilder.add("maitrd", "udp", 997);
        servicesBuilder.add("busboy", "tcp", 998);
        servicesBuilder.add("puparp", "udp", 998);
        servicesBuilder.add("garcon", "tcp", 999);
        servicesBuilder.add("applix", "udp", 999);
        servicesBuilder.add("puprouter", "tcp", 999);
        servicesBuilder.add("puprouter", "udp", 999);
        servicesBuilder.add("cadlock2", "tcp", 1000);
        servicesBuilder.add("cadlock2", "udp", 1000);
        servicesBuilder.add("surf", "tcp", 1010);
        servicesBuilder.add("surf", "udp", 1010);
        servicesBuilder.add("exp1", "tcp", 1021);
        servicesBuilder.add("exp1", "udp", 1021);
        servicesBuilder.add("exp2", "tcp", 1022);
        servicesBuilder.add("exp2", "udp", 1022);
        return servicesBuilder.build();
    }

    static /* synthetic */ IANAServicesDB access$000() {
        return IANAServicesDB.buildServices();
    }

    private static final class ServicesBuilder {
        private static final List<String> emptyAliases = Collections.emptyList();
        final Map<String, Service> tcpNameToService = new HashMap<String, Service>();
        final Map<String, Service> udpNameToService = new HashMap<String, Service>();
        final Map<Integer, Service> tcpPortToService = new HashMap<Integer, Service>();
        final Map<Integer, Service> udpPortToService = new HashMap<Integer, Service>();

        private ServicesBuilder() {
        }

        public final void add(String string, int n) {
            String[] stringArray = string.split("/");
            this.add(stringArray[0], stringArray[1], n);
        }

        public final void add(String string, String string2, int n) {
            Service service = new Service(string, n, string2, emptyAliases);
            if ("tcp".equals(string2)) {
                this.tcpNameToService.put(string, service);
                this.tcpPortToService.put(n, service);
            } else if ("udp".equals(string2)) {
                this.udpNameToService.put(string, service);
                this.udpPortToService.put(n, service);
            }
        }

        IANAServicesDB build() {
            return new IANAServicesDB(this.tcpNameToService, this.udpNameToService, this.tcpPortToService, this.udpPortToService);
        }
    }

    private static final class SingletonHolder {
        public static final IANAServicesDB INSTANCE = IANAServicesDB.access$000();

        private SingletonHolder() {
        }
    }
}

